﻿//****************************************************************************
//Copyright (C) 2005 Macromedia, Inc. All Rights Reserved.
//The following is Sample Code and is subject to all restrictions on
//such code as contained in the End User License Agreement accompanying
//this product.
//****************************************************************************

import mx.core.UIComponent;

[Event("change")]
class Dial extends UIComponent
{
	// Components must declare these to be proper
	// components in the components framework
	static var symbolName:String = "Dial";
	static var symbolOwner:Object = Dial;
	var className:String = "Dial";

	// The needle and dial movie clips that are
	// the component's graphical representation
	private var needle:MovieClip;
	private var dial:MovieClip;
	private var boundingBox_mc:MovieClip;

	// The "value" property is a getter/setter,
	// so that we can update the needle's position
	// when the value is set.  This is a private
	// variable which stores the value.
	private var __value:Number = 0;

	// This flag is set when the user drags the
	// needle with the mouse, and cleared afterwards.
	private var dragging:Boolean = false;



	// Constructor; currently does nothing.
	function Dial() {
	}

	// Initialization code.  During initialization, we set up
	// event handlers on the needle so that when the user
	// clicks the mouse and drags, we can change the needle's
	// position and update our value.
	function init():Void {
		super.init();
		useHandCursor = false;
		boundingBox_mc._visible = false;
		boundingBox_mc._width = 0;
		boundingBox_mc._height = 0;
	}

	private function createChildren():Void
	{
		dial = createObject("DialFinal", "dial", 10);
		size();
	}

	// The draw method is invoked after the component has
	// been invalidated, by someone calling invalidate().
	// This is better than redrawing from within the set function
	// for value, because if there are other properties, it's
	// better to batch up the changes into one redraw, rather
	// than doing them all individually.  This approach leads
	// to more efficiency and better centralization of code.
	function draw():Void {
		super.draw();
		dial.needle._rotation = value;
	}

	// The size method is invoked when the component's size
	// changes.  We use the opportunity to resize our children,
	// the dial and needle graphics.
	function size():Void {
		super.size();
		dial._width  = width;
		dial._height = height;
		// cause the needle to get redrawn, in case it needs it
		invalidate();
	}

   	// This is the getter/setter for the value property.
	// The [Inspectable] metadata makes the property show up
	// in the Properties Inspector.  This is a getter/setter
	// so that we can call invalidate and force the component
	// to redraw, when the value is changed.
	[Bindable]
	[ChangeEvent("change")]
	[Inspectable(defaultValue=0)]
	function set value (val:Number)
	{
		__value = val;
		invalidate();
	}

	function get value ():Number
	{
		return twoDigits(__value);
	}

	function twoDigits(x:Number):Number
	{
		return (Math.round(x * 100) / 100);
	}


	// tells the component to expect mouse presses
	function onPress()
	{
		beginDrag();
	}

	// When the dial is pressed, the dragging flag is set.
	// The mouse events are assigned callback functions.
	function beginDrag()
	{
		dragging = true;
		onMouseMove = mouseMoveHandler;
		onMouseUp = mouseUpHandler;
	}

	// Remove the mouse events when the drag is complete,
	// and clear the flag.
	function mouseUpHandler()
	{
		dragging = false;
		delete onMouseMove;
		delete onMouseUp;
	}

	function mouseMoveHandler()
	{
		// Figure out the angle
		if (dragging) {
			var x:Number = _xmouse - width/2;
			var y:Number = _ymouse - height/2;

			var oldValue:Number = value;
			var newValue:Number = 90+180/Math.PI*Math.atan2(y, x);
			if (newValue<0) {
				newValue += 360;
			}
			if (oldValue != newValue) {
				value = newValue;
				dispatchEvent( {type:"change"} );
			}
		}
	}
}

